//LidScrewThreads.scad;

//Use LidScrewThread four times to generate 
//four screw holes;

//LidScrewThread generates one screw 
//thread object centered at the origin, 
//with the screw head resting on the 
//XY plane and the screw thread 
//standing vertically above that plane;

include <UNO_Dimensions.scad>
use <UNO_LidScrewThread.scad>;

module LidScrewThreads(HolePhi)
{

echo("Begin LidScrewThreads");
      
//DeltaZ is constant for all screws;
DeltaZ = -Fuzz;

//Four screw objects;
echo("BL = ", LidBLx, LidBLy);
translate([LidBLx, LidBLy, DeltaZ])
    LidScrewThread(HolePhi);

echo("BR = ", LidBRx, LidBRy);
translate([LidBRx, LidBRy, DeltaZ])
    LidScrewThread(HolePhi);

echo("TR = ", LidTRx, LidTRy);
translate([LidTRx, LidTRy, DeltaZ])
    LidScrewThread(HolePhi);

echo("TL = ", LidTLx, LidTLy);
translate([LidTLx, LidTLy, DeltaZ])
    LidScrewThread(HolePhi);

}
//
